#if NUNIT
#region References

using System;
using System.Collections;
using System.Net;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.UnitTests;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using PATIENT_LOCATION = gov.va.med.vbecs.Common.VbecsTables.PatientLocation;
using SProc = gov.va.med.vbecs.Common.VbecsStoredProcs;

#endregion

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_PatientLocation : BaseTest
	{
		#region Variables & Setup

		PatientLocation _patientLocation;
        Guid _patientGuid = Guid.Empty;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			//
			_patientLocation = new PatientLocation();
			//
			// Ensure we have at least one entry in Patient Location
            //DataRow drTest = UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned("SELECT TOP 1 PatientGuid FROM PatientLocation WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'" );
            //if (drTest == null)
            //{
                UnitTestUtil.RunSQL("DELETE FROM PatientLocation");     //TODO: Fix this lazy approach, tests create duplicate patient locations
			    DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			    _patientGuid = (System.Guid) dtPatient.Rows[0][PATIENT_LOCATION.PatientGuid];
				//
				DataTable dtPatientLocation = PatientLocation.GetPatientLocationDataTable();
				DataRow drPatientLocation = dtPatientLocation.NewRow();
				//
				drPatientLocation[PATIENT_LOCATION.PatientGuid] = _patientGuid;
				drPatientLocation[PATIENT_LOCATION.InPatientIndicator] = true;
				drPatientLocation[PATIENT_LOCATION.LocationName] = "3W GS-KC";
				drPatientLocation[PATIENT_LOCATION.LocationRoomBed] = "NW303-3";
				drPatientLocation[PATIENT_LOCATION.DivisionCode] = "589";
				drPatientLocation[PATIENT_LOCATION.LastUpdateFunctionId] = Common.UpdateFunction.HL7PatientUpdateInterface;
				drPatientLocation[PATIENT_LOCATION.LastUpdateUser] = "UNIT_TEST";
				//
				dtPatientLocation.Rows.Add( drPatientLocation );
				//
				ArrayList storedProcedureList = new ArrayList();
				ArrayList updatedTableList = new ArrayList();
				//
				storedProcedureList.Add( SProc.HL7InsertPatientLocation.StoredProcName );
				updatedTableList.Add( dtPatientLocation.Copy()  );
				//
				Assert.IsTrue ( PatientChange.UpdatePatientInformation(storedProcedureList, updatedTableList) );
            //}
            //_patientGuid = (_patientGuid == System.Guid.Empty) ? (System.Guid) drTest[PATIENT_LOCATION.PatientGuid] : _patientGuid;
		}

		#endregion

		#region Properties

		[Test]
		public void InPatientIndicator_Pass()
		{
			Assert.AreEqual( false, this._patientLocation.InPatientIndicator, "Initial Value" );

			this._patientLocation.InPatientIndicator = true;
			Assert.AreEqual( true, this._patientLocation.InPatientIndicator, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InPatientIndicator_Fail()
		{
		}

		[Test]
		public void Name_Pass()
		{
			Assert.IsNull( this._patientLocation.Name, "Intial Value" );

			string tmpValue = new Random().Next(1,99999).ToString();
			this._patientLocation.Name = tmpValue;
			Assert.AreEqual( tmpValue, this._patientLocation.Name, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocationName_Fail()
		{
		}

		[Test]
		public void RoomBed_Pass()
		{
			Assert.IsNull( this._patientLocation.RoomBed, "Intial Value" );

			string tmpValue = new Random().Next(1,99999).ToString();
			this._patientLocation.RoomBed = tmpValue;
			Assert.AreEqual( tmpValue, this._patientLocation.RoomBed, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocationRoomBed_Fail()
		{
		}

		[Test]
		public void Ien_Pass()
		{
			Assert.IsNull( this._patientLocation.Ien, "Intial Value" );

			string tmpValue = new Random().Next(1,99999).ToString();
			this._patientLocation.Ien = tmpValue;
			Assert.AreEqual( tmpValue, this._patientLocation.Ien, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocationIen_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			Assert.IsNull( this._patientLocation.DivisionCode, "Intial Value" );

			string tmpValue = new Random().Next(1,99999).ToString();
			this._patientLocation.DivisionCode = tmpValue;
			Assert.AreEqual( tmpValue, this._patientLocation.DivisionCode, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocationDivision_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LocationDivisionName_Fail()
		{
		}

		[Test]
		public void PatientGuid_Pass()
		{
			Assert.AreEqual( System.Guid.Empty, this._patientLocation.PatientGuid, "Initial Value" );

			System.Guid tmpValue = System.Guid.NewGuid();
			this._patientLocation.PatientGuid = tmpValue;
			Assert.AreEqual( tmpValue, this._patientLocation.PatientGuid, "Set Value" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientGuid_Fail()
		{
		}

		#endregion

		#region Methods

		[Test]
		public void GetCurrentPatientLocation_Pass()
		{
			Assert.NotNull( PatientLocation.GetCurrentPatientLocation(_patientGuid));
		}

		[Test]
		public void GetCurrentPatientLocation_Fail()
		{
			Assert.IsNull( PatientLocation.GetCurrentPatientLocation(System.Guid.NewGuid()));
		}

		[Test]
		public void GetHL7PatientLocation_Pass()
		{
			Assert.NotNull( PatientLocation.GetHL7PatientLocation(_patientGuid));
		}

		[Test]
		public void GetHL7PatientLocation_Fail()
		{
			Assert.IsNull( PatientLocation.GetHL7PatientLocation(System.Guid.NewGuid()));
		}

		#endregion
	}
}
#endif